#include "HowToPlay.h"



HowToPlay::HowToPlay(sf::RenderWindow* hwnd, Input* input) : Level(hwnd, input)
{
	backgroundTexture.loadFromFile("Assets/Sprites/Levels/How To Play/background.png");	//Load the background texture and set it to the window size
	backgroundSprite.setTexture(&backgroundTexture);
	backgroundSprite.setSize(sf::Vector2f(1024, 768));

	startTexture.loadFromFile("Assets/Sprites/Levels/Main Menu/startGame.png");	//Load the start game sprite for mouse input
	startSprite.setTexture(&startTexture);
	startSprite.setPosition(720, 640);
	startSprite.setSize(sf::Vector2f(297, 26));
	startSprite.setCollisionBox(sf::FloatRect(0, 0, 297, 26));	//Collision box for mouse input
}


HowToPlay::~HowToPlay()
{
}

void HowToPlay::handleInput(float dt)
{

}

void HowToPlay::update(float dt)
{
	mouseCursor.update(userInput->getMouseX(), userInput->getMouseY());

	if (userInput->isMouseLeftDown() == true)	//If we click the left mouse button
	{
		if (Collision::checkBoundingBox(&mouseCursor, &startSprite))	//If we collide with the start game text
		{
			currentLevel = Level::QueryLevel(LevelType_Lives);	//We set the level to the lives screen, which eventually progresses onto the main game
		}
	}
}

void HowToPlay::render()
{
	window->draw(backgroundSprite);
	window->draw(startSprite);
}
